<?php
/**
 * Template Name: Uczniowie
 */
?>

<?php get_header(); ?>

	<div class="item teaser-page-list">
		<div class="container_16">
			<aside class="grid_10">
				<h1 class="page-title"><?php the_title(); ?></h1>
			</aside>
			<?php if ( ot_get_option('charitas_breadcrumbs') != "off") { ?>
				<div class="grid_6">
					<div id="rootline">
						<?php charitas_breadcrumbs(); ?>	
					</div>
				</div>
			<?php } ?>
			<div class="clear"></div>
		</div>
	</div>
	
	<div id="main" class="site-main container_16">
		<div class="inner">
			<div id="primary" class="grid_11 suffix_1">
				
                <article id="post-<?php the_ID(); ?>" <?php post_class("single"); ?>>
                    <div class="entry-content">
                        
                        <?php $args = array( 'post_type' => 'pupil','post_status' => 'publish', 'paged'=> $paged, 'posts_per_page'=>-1); ?>
                        <?php $wp_query = null; ?>
                        <?php $wp_query = new WP_Query( $args ); ?>
                        <?php if ( $wp_query->have_posts() ) : while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>
                            
                            <?php 
                                $attachment_id = get_field('photo');
                                $size = "employee_thumbnail"; // (thumbnail, medium, large, full or custom size)
                                $image = wp_get_attachment_image_src( $attachment_id, $size );
                            ?>
                            
                            <div class="candidate radius grid_5">
                                <div class="candidate-margins">
                                     <img src="<?php echo $image[0]; ?>" class="attachment-candidate-thumb size-candidate-thumb wp-post-image" alt="" width="200" height="210">																
                                     <div class="name"><?php the_title(); ?></div>
                                </div>
                            </div>
                                                        
                        <?php endwhile; wp_reset_postdata(); ?>
                        <?php else : ?>
                            <p><?php _e('Sorry, no posts matched your criteria.', 'charitas'); ?></p>
                        <?php endif; ?>
                        
                        
                    </div>
                </article>             
			</div>
	
			<?php get_sidebar(); ?>
			<div class="clear"></div>
		</div>
	</div>
<?php get_footer(); ?>